﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class ProductsBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Products GetItem(Guid productsID, string keyword)
        {
            return ProductsDB.GetItem(productsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Delete,false)]
        public static bool Delete()
        {
            return ProductsDB.Delete();
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<Products> GetList(Guid productsID, string keyword)
        {
            return ProductsDB.GetList(productsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid productsID, string keyword)
        {
            return ProductsDB.GetDataTable(productsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid productsID, string keyword)
        {
            return ProductsDB.GetDataSet(productsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(Products myProducts)
        {
            //if (!GlobalConfigurations.AppConfiguration.IsLocalDatabase) //If local database, first complete the current transaction because SQL CE won't support distributed transaction
            //{
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                ProductsDB.Save(myProducts);

                foreach (ProductsXCategory myCategory in myProducts.ProductsXCategoryList)
                {
                    myCategory.Mode = myProducts.Mode;
                    myCategory.ProductsID = myProducts.UniqueID;
                    ProductsXCategoryDB.Save(myCategory);
                }

                foreach (ProductsXMeasurements mySizes in myProducts.ProductMeasurementList)
                {
                    mySizes.ProductID = myProducts.UniqueID;
                    mySizes.BaseSizeID = myProducts.ProductMeasurementID;
                    ProductsXMeasurementsDB.Save(mySizes);
                }

                myTransactionScope.Complete();
                return true;
            }
        //}
        //    else
        //    {
        //        ProductsDB.Save(myProducts);
        //        foreach (ProductsXCategory myCategory in myProducts.ProductsXCategoryList)
        //        {
        //            myCategory.Mode = myProducts.Mode;
        //            myCategory.ProductsID = myProducts.UniqueID;
        //            ProductsXCategoryDB.Save(myCategory);
        //        }
        //        return true;
        //    }
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool SaveLocal(Products myProducts)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                ProductsDB.SaveLocal(myProducts);
                foreach (ProductsXCategory myCategory in myProducts.ProductsXCategoryList)
                {
                    myCategory.Mode = myProducts.Mode;
                    myCategory.ProductsID = myProducts.UniqueID;
                    ProductsXCategoryDB.Save(myCategory);
                }

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
